/**
 * @package   	JCE
 * @copyright 	Copyright (c) 2009-2020 Ryan Demmer. All rights reserved.
 * @license   	GNU/GPL 2 or later - http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * JCE is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */
(function ($) {
    $(document).ready(function () {

        $('ul.newsfeed').addClass('loading');

        // Get feed
        $.getJSON("index.php?option=com_jce&task=cpanel.feed", {}, function (r) {
            $('.wf-cpanel-newsfeed').removeClass('loading').empty();

            if (!r || !r.feeds) {
                return;
            } 

            $.each(r.feeds, function (k, n) {
                $('.wf-cpanel-newsfeed').append('<li><a href="' + n.link + '" target="_blank" title="' + n.title + '">' + n.title + '</a></li>');
            });

        });

        // Open config/preferences dialog
        $('#newsfeed_enable').click(function (e) {
            $('#toolbar-options button').click();
            e.preventDefault();
        });
    });
})(jQuery);